;****************************************************************************
;*                                                                          *
;* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY    *
;* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE      *
;* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR    *
;* PURPOSE.                                                                 *
;*                                                                          *
;* Copyright(C) 1997-98 by PSH //UCL.                                       *
;*                                                                          *
;****************************************************************************
;*                                                                          *
;* This is ControlDispatch for VxD                                          *
;*                                                                          *
;****************************************************************************

PAGE 58,132
;******************************************************************************
TITLE CONTROL - ControlDispatch for VxD
;******************************************************************************
;
    .386p

;******************************************************************************
;                I N C L U D E S
;******************************************************************************

    .xlist
    include vmm.inc
    include debug.inc
    .list

extern _HASP_EMU:proc
extern _Encrypt16:proc
extern _Decrypt16:proc
extern _LoadConfig:proc

; the following equate makes the VXD dynamically loadable.
HASP95_DYNAMIC   EQU 1

; Device ID (must be 3721)
HASP95_DEVICE_ID EQU 3721H

;============================================================================
;        V I R T U A L   D E V I C E   D E C L A R A T I O N
;============================================================================

DECLARE_VIRTUAL_DEVICE HASP95, 1, 0, HASP95EMU_Control, HASP95_DEVICE_ID, \
                        UNDEFINED_INIT_ORDER,HASP95EMU_API_Proc,HASP95EMU_API_Proc

VxD_LOCKED_CODE_SEG

;===========================================================================
;
;   PROCEDURE: HASP95_Control
;
;   DESCRIPTION:
;    Device control procedure for VxD
;
;   ENTRY:
;    EAX = Control call ID
;
;   EXIT:
;    If carry clear then
;        Successful
;    else
;        Control call failed
;
;   USES:
;    EAX, EBX, ECX, EDX, ESI, EDI, Flags
;
;============================================================================

BeginProc HASP95EMU_Control
    Control_Dispatch DEVICE_INIT, HASP95EMU_Init
    Control_Dispatch SYS_DYNAMIC_DEVICE_INIT, HASP95EMU_Dynamic_Init, sCall
    Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT, HASP95EMU_Dynamic_Exit, sCall
    Control_Dispatch W32_DEVICEIOCONTROL,     HASP95EMU_DeviceIOControl, sCall, <ecx, ebx, edx, esi>
    clc
    ret
EndProc HASP95EMU_Control

VxD_LOCKED_CODE_ENDS

VxD_CODE_SEG

BeginDoc
;   ENTRY:
;       ebp -> Client data area
;       ebx -> Current VMCB
;
;
;==============================================================================
EndDoc

; API Entry for DOS Apps

BeginProc HASP95EMU_API_Proc

		
		call _EMUBreak				; For Debug

		xor	edi, edi
		mov	di, [ebp+18h]	; ECX
		cmp	di, 32h	
		jz	short ReqNormal
		cmp	di,28h
		jb 	ErrorMapFlat

		mov	ax, 1404h
		VMMcall	Map_Flat
		jmp	short CheckErr

ReqNormal:

		sub	di, 0Ah		; DI=28h
		sub	word ptr [ebp+18h], 0Ah	; For ret ?

		mov	ax, 1004h	; ---
		VMMcall	Map_Flat
CheckErr:	cmp	eax, -1
		jz	short ErrorMapFlat

		push	eax
		call	_Decrypt16			; Decrypt
		pop eax


NotBlock:	push eax
		call _HASP_EMU				; Emulate
		pop eax

Encrypt:	push	eax
		call	_Encrypt16			; Encrypt
		pop eax


		clc	
		ret
; 

ErrorMapFlat:	stc	
		ret

EndProc HASP95EMU_API_Proc

BeginProc HASP95EMU_Init			; Init VxD
		call _EMUBreak			; For Debug
		call _LoadConfig		; Load Config
		cmp eax,-1
		je ErrorLoad
		clc
		ret
ErrorLoad:	stc
		ret
	
EndProc HASP95EMU_Init


BeginProc _EMUBreak				; INT 3 for Debug
;		int 3
		ret
EndProc _EMUBreak

VxD_CODE_ENDS

    END

